<?php 
$custom_link_login = get_theme_mod( 'custom_link_login_setting' );
$custom_link_daftar = get_theme_mod( 'custom_link_daftar_setting');

$custom_color_header = get_theme_mod( 'custom_color_header', '#1e0000' );
$custom_color_background = get_theme_mod( 'custom_color_background', '#000000' );
$custom_menu_game = get_theme_mod( 'custom_menu_game', '#d51307' );
$custom_color_login = get_theme_mod( 'custom_color_login', '#d51307' );
$custom_color_daftar = get_theme_mod( 'custom_color_daftar', '#f6bb23' );
$custom_color_footer = get_theme_mod( 'custom_color_footer', '#4b120f' );
?>

<amp-sidebar id="sidenav" layout="nodisplay" side="right">
        <div class="sidenav__header">
            <div class="sidenav__header-user"><span>Selamat Datang</span></div>
            <div class="sidenav__header-logo">
            <?php
            if ( has_custom_logo() ) {
                $custom_logo_id = get_theme_mod( 'custom_logo' );
                $logo_url = wp_get_attachment_image_url( $custom_logo_id, 'full' ); // 'full' indicates the image size
                echo '<amp-img src="' . esc_url( $logo_url ) . '" alt="WebsiteLogo" width="180" height="59" layout="intrinsic"></amp-img>';
            } else {
                echo '<amp-img src="" alt="WebsiteLogo" width="180" height="59" layout="intrinsic"></amp-img>';
            }
            ?>
            </div>
            <div class="sidenav__header-button">
                <div class="sidenav-button-title">Silakan Login atau Mendaftar</div>
				<div class="sidenav-button">
					<?php
					// Mendapatkan ID menu berdasarkan lokasi menu
					$locations = get_nav_menu_locations();
					$header_menu_id = $locations['header-menu'];

					// Mendapatkan daftar item menu dari database
					$menu_items = wp_get_nav_menu_items($header_menu_id);

					// Periksa apakah ada item menu
					if ($menu_items) {
						// Loop melalui setiap item menu
						foreach ($menu_items as $menu_item) {
							// Dapatkan kelas menu yang telah ditetapkan
							$classes = $menu_item->classes;
							$class_string = implode(' ', $classes); // Ubah array kelas menjadi string

							// Tampilkan setiap item menu sebagai link dengan kelas kustom
							echo '<a class="' . $class_string . '" href="' . $menu_item->url . '">' . $menu_item->title . '</a>';
						}
					}
					?>
					
				</div>
            </div>
        </div>
		<?php
			wp_nav_menu( array(
				'theme_location' => 'sidenav-menu',
				'menu_class' => 'sidenav-list'
			) );
			?>
    </amp-sidebar>
